var express = require('express');
var router = express.Router();
const mysql = require('mysql');
const { Pool } = require('pg');
const dbConfig = require('../db');

/* GET home page. */
router.get('/', function(req, res, next) {
  res.render('index', { title: 'Express' });
});

// 链接postgresql数据库，并执行传入的SQL语句
router.post('/execute-sql-pg', async (req, res) => {
  const { sql, databaseName } = req.body;
  // 禁止运行增/删/改语句
  if (sql.toLowerCase().trim().startsWith('insert') ||
      sql.toLowerCase().trim().startsWith('delete') ||
      sql.toLowerCase().trim().startsWith('update')) {
      res.json({ error: '你无权对数据库进行增删改操作' })
  }

  const pool = new Pool({
    user: dbConfig.user,
    password: dbConfig.password,
    host: dbConfig.host,
    port: dbConfig.port,
    database: databaseName || 'dwd_infipark'
  });

  if (!sql) {
    res.json({ error: 'No SQL query provided' })
  }

  try {
    const result = await pool.query(sql);
    res.json(result.rows); // 返回查询结果
  } catch (err) {
    console.error('Error executing SQL:', err);
    res.json({ error: 'Error executing SQL: ' + err.message });
  }
  pool.end();
  console.log('Postgresql connection closed');
})

// 动态根据关键字查询出匹配的字段名
router.get('/get-10-top-list', async (req, res) => {
  const { keyword, databaseName, tableName } = req.query;
  if(!keyword) {
    res.json({ error: 'No keyword provided' })
  }
  const client = new Pool({
    user: dbConfig.user,
    password: dbConfig.password,
    host: dbConfig.host,
    port: dbConfig.port,
    database: databaseName || 'dwd_infipark'     // 数据库名称
  });

  try {
    // 查询表的字段信息
    const columnsQuery = `
      SELECT column_name, data_type
      FROM information_schema.columns
      WHERE table_name = '${tableName}' AND table_schema = 'public'
    `;
    
    const columnsResult = await client.query(columnsQuery);
    const columns = columnsResult.rows;
    
    // 构造动态的 WHERE 子句
    const conditions = columns
      .filter((col) => col.data_type === 'text' || col.data_type === 'character varying' || col.data_type === 'varchar')
      .map((col) => `${col.column_name} ILIKE $1`)
      .join(' OR ');

    if (conditions.length === 0) {
      return res.status(400).send('表中没有可搜索的文本字段');
    }

    const query = `
      SELECT *
      FROM ${tableName}
      WHERE ${conditions}
      LIMIT 10
    `;
    const params = [`%${keyword}%`]; // 模糊匹配模式

    // 执行查询
    const result = await client.query(query, params);
    res.json(result.rows);
    client.end();
  } catch (err) {
    console.error('查询失败:', err);
    res.status(500).send('查询失败');
    client.end();
  }
})


module.exports = router;
