import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import { ElementPlusResolver } from 'unplugin-vue-components/resolvers'
import { compression } from 'vite-plugin-compression2'

// https://vite.dev/config/
const BASE_PATH = process.env.REACT_APP_BASE_PATH || '/';
export default defineConfig({
base: BASE_PATH,
  plugins: [
    vue(),
    AutoImport({
      resolvers: [ElementPlusResolver()],
    }),
    Components({
      resolvers: [ElementPlusResolver()],
    }),
    compression({
      threshold: 2000,
      skipIfLargerOrEqual:true,
    })
  ],
  css: {
    preprocessorOptions: {
      less: {
        // 全局引入less
        // additionalData: `@import "./src/assets/scss/variables.scss";`
      }
    }
  },
  server: {
    proxy: {
        '/v1': {
        target: 'http://10.82.14.177',
        changeOrigin: true,
        // rewrite: (path) => path.replace(/^\/v1/, '')
      }
    }
  },
  build: {
    chunkSizeWarningLimit: 500,
    rollupOptions: {
      // 将每个包都作为一个JS打包
      // output: {
      //   manualChunks(id) {
      //     if (id.includes('node_modules')) {
      //       const parts = id.split('node_modules/')[1].split('/');
      //       return parts[0]; // 按依赖包名分包
      //     }
      //     return 'default'; // 其他模块默认分包
      //   },
      // },
      output: {
        manualChunks(id) {
          // 将node_modules下的包打包到一个chunk中
          if (id.includes('node_modules')) {
            return "vendor";
          }
        },
      }
    },
    minify: 'terser',
    terserOptions: {
      compress: {
        drop_console: true,
        drop_debugger: true,
      },
    },
  }
})
