import { defineStore } from 'pinia'

export const useTaskStore = defineStore('task', {
  state: () => {
    return { 
        taskId: '', // 当前任务id
        conversation_id: '', // 当前会话id
        message_id: '', // 当前消息id
        workflow_run_id: '' // 当前工作流运行id
    }
  },
  actions: {
    setTaskId (taskId) {
      this.taskId = taskId
    },
    setConversationId (conversation_id) {
      this.conversation_id = conversation_id
    },
    setMessageId (message_id) {
      this.message_id = message_id
    },
    setWorkflowRunId (workflow_run_id) {
      this.workflow_run_id = workflow_run_id
    },
    clear () {
      this.taskId = ''
      this.conversation_id = ''
      this.message_id = ''
      this.workflow_run_id = ''
    }
  },
  persist: true
})