import { createApp } from 'vue'
import { createPinia } from 'pinia'
import piniaPluginPersistedstate from 'pinia-plugin-persistedstate';
import App from './App.vue'
import * as ElementPlusIconsVue from '@element-plus/icons-vue'
import vAdjustWidth from './directives/v-adjust-width.js'
import './theme/theme.less'
import 'element-plus/dist/index.css'
import './style.css'
import './assets/icons/iconfont.css'

const app = createApp(App)
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
  app.component(key, component)
}

// 注册指令
app.directive('adjust-width', vAdjustWidth);

const pinia = createPinia()
pinia.use(piniaPluginPersistedstate);
app.use(pinia)

app.mount('#app')
