// src/directives/v-adjust-width.js

export default {
    mounted(el) {
      const adjustWidth = () => {
        const parentWidth = document.querySelector('#main-container').clientWidth;
        // console.log('parentWidth:', parentWidth);
        
        if (parentWidth <= 740) {
          el.style.width = '100%';
        } else {
          el.style.width = '580px';
        }
      };
  
      const handleResize = () => {
        adjustWidth();
      };
  
      window.addEventListener('resize', handleResize);
      handleResize(); // 初始化时调整宽度
  
      el.__resizeHandler = handleResize;
    },
    unmounted(el) {
    //   console.log('v-adjust-width unmounted');
      window.removeEventListener('resize', el.__resizeHandler);
    }
  };