import request from './request.js';
import difyConfig from '../config.js';
import { useAppStore } from '../store/app.js';

const difyApi = {
    // 发送对话消息
    chatMessage: () => {
        const appStore = useAppStore();
        return {
            url: `${difyConfig.DIFY_URL}/chat-messages`,
            method: 'post',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${difyConfig.API_KEY}`
            },
            user: appStore.userId || difyConfig.USER_ID
        }
    },
    // 上传文件
    filesUpload: async (data) => await request.post('/files/upload', data),
    // 停止响应
    stop: async (task_id, data) => {
        const appStore = useAppStore()
        return await request.post(`/chat-messages/${task_id}/stop`, {user: appStore.userId || difyConfig.USER_ID, ...data})
    },
    // 消息反馈
    feedback: async (message_id, data) => await request.post(`/messages/${message_id}/feedbacks`, data),
    // 获取下一轮建议列表
    getNextSuggestions: async (message_id, params) => await request.get(`/messages/${message_id}/suggested`, params),
    // 获取对话历史记录
    getChatHistory: async (params) => await request.get('/messages', params),
    // 获取会话列表
    getChatList: async (params) => await request.get('/conversations', params),
    // 删除会话
    deleteChat: async (conversation_id) => await request.delete(`/conversations/${conversation_id}`, null, {}),
    // 会话重命名
    renameChat: async (conversation_id, data) => await request.post(`/conversations/${conversation_id}/name`, data),
    // 语音转文字
    voiceToText: async (data) => await request.post('/audio-to-text', data),
    // 文字转语音
    textToVoice: async (data) => await request.post('/text-to-audio', data),
    // 获取应用基本信息
    getAppInfo: async () => await request.get('/info'),
    // 获取应用参数
    getAppParams: async () => await request.get('/parameters'),
    // 获取应用Meta信息
    getAppMeta: async () => await request.get('/meta')
}

export default difyApi