(function() {
    // 获取URL
    const urlParams = new URLSearchParams(window.location.search);
    const baseUrl = urlParams.get('url') || 'https://tk-test.infi-inside.com:2443';

    // 创建悬浮按钮
    const button = document.createElement('button');
    button.id = 'chatbot-bubble-button';
    button.style.position = 'fixed';
    button.style.bottom = '20px';
    button.style.right = '20px';
    button.style.width = '50px';
    button.style.height = '50px';
    button.style.border = 'none';
    button.style.borderRadius = '50%';
    button.style.display = 'flex';
    button.style.alignItems = 'center';
    button.style.justifyContent = 'center';
    button.style.fontSize = '18px';
    button.style.cursor = 'pointer';
    button.style.backgroundColor = 'transparent';

    // Create an img element
    const img = document.createElement('img');
    img.src = baseUrl + '/deepseek.png'; // Replace with the path to your image
    img.style.width = '60px';
    // img.style.height = '100%';
    img.style.objectFit = 'cover';

    // Append the img element to the button
    button.appendChild(img);

    document.body.appendChild(button);

    // 创建iframe容器
    const iframeContainer = document.createElement('div');
    iframeContainer.id = 'chatbot-bubble-window';
    iframeContainer.style.position = 'fixed';
    iframeContainer.style.bottom = '80px';
    iframeContainer.style.right = '20px';
    iframeContainer.style.width = '650px'; // 24rem
    iframeContainer.style.height = '85%'; // 40rem
    iframeContainer.style.display = 'none';
    iframeContainer.style.border = '1px solid #9a9a9a';
    iframeContainer.style.borderRadius = '8px';
    iframeContainer.style.backgroundColor = '#f9f9f9';
    iframeContainer.style.zIndex = '9999';

    // 创建关闭按钮并插入SVG
    const closeButton = document.createElement('button');
    closeButton.style.position = 'absolute';
    closeButton.style.top = '15px';
    closeButton.style.right = '5px';
    closeButton.style.width = '20px';
    closeButton.style.height = '20px';
    closeButton.style.border = 'none';
    closeButton.style.backgroundColor = 'transparent';
    closeButton.style.cursor = 'pointer';

    const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
    svg.setAttribute("t", "1745391895314");
    svg.setAttribute("class", "icon");
    svg.setAttribute("viewBox", "0 0 1024 1024");
    svg.setAttribute("version", "1.1");
    svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
    svg.setAttribute("width", "16");
    svg.setAttribute("height", "16");

    const path = document.createElementNS("http://www.w3.org/2000/svg", "path");
    path.setAttribute("d", "M512 0C229.273 0 0 229.273 0 512s229.273 512 512 512 512-229.273 512-512S794.727 0 512 0z m241.36 701.668a36.571 36.571 0 1 1-51.715 51.715L512 563.715 322.355 753.36a36.571 36.571 0 1 1-51.715-51.715L460.285 512 270.64 322.355a36.571 36.571 0 0 1 51.715-51.715L512 460.285 701.645 270.64a36.571 36.571 0 0 1 51.715 51.715L563.715 512z");
    path.setAttribute("fill", "#D81E06");

    svg.appendChild(path);
    closeButton.appendChild(svg);


    iframeContainer.appendChild(closeButton);

    // 创建iframe
    const iframe = document.createElement('iframe');
    // 获取URL
    
    iframe.src = baseUrl; // 替换为你的聊天窗口页面地址
    iframe.style.width = '100%';
    iframe.style.height = '100%';
    iframe.style.border = 'none';
    iframe.style.borderRadius = '8px';
    iframe.sandbox = 'allow-scripts allow-top-navigation allow-same-origin allow-forms allow-popups allow-modals';

    iframeContainer.appendChild(iframe);
    document.body.appendChild(iframeContainer);

    // 添加按钮点击事件
    button.addEventListener('click', () => {
        iframeContainer.style.display = iframeContainer.style.display === 'none' ? 'block' : 'none';
    });

    // 添加关闭按钮点击事件
    closeButton.addEventListener('click', () => {
        iframeContainer.style.display = 'none';
    });
})();