import { fileURLToPath } from 'url';
import path, { dirname } from 'path';
import fs from 'fs';
import { minify } from 'terser';

// 获取当前模块的路径
const __filename = fileURLToPath(import.meta.url);
const __dirname = dirname(__filename);

// 定义源文件路径和目标路径
const sourceFilePath = path.resolve(__dirname, 'iframePlugin/embed.js'); // 替换为实际的文件路径
const targetFilePath = path.resolve(__dirname, 'dist/embed.min.js'); // 替换为压缩后的目标文件路径

// 读取源文件内容
fs.readFile(sourceFilePath, 'utf8', (err, content) => {
  if (err) {
    console.error('读取文件失败:', err);
    return;
  }

  // 使用 Terser 压缩 JavaScript
  minify(content).then((result) => {
    // 写入压缩后的文件到目标路径
    fs.writeFile(targetFilePath, result.code, (err) => {
      if (err) {
        console.error('写入文件失败:', err);
      } else {
        console.log(`文件已成功压缩并保存到 ${targetFilePath}`);
      }
    });
  }).catch((err) => {
    console.error('压缩文件失败:', err);
  });
});